using System;
using System.Collections.Generic;

public class Program
{
    static void GenAllProducts(long n, int maxLen, long curr, long prod, int len, Dictionary<long, long> minNum)
    {
        if (len > 0)
        {
            if (!minNum.ContainsKey(prod) || curr < minNum[prod])
                minNum[prod] = curr;
        }
        if (len == maxLen) return;
        for (int d = 1; d <= 10; d++)
        {
            long next = curr * 10 + d;
            GenAllProducts(n, maxLen, next, prod * d, len + 1, minNum);
        }
    }

    public static void Main(string[] args)
    {
        int T = int.Parse(Console.ReadLine());
        for (int t = 0; t < T; t++)
        {
            long n = long.Parse(Console.ReadLine());
            int maxLen = n.ToString().Length;
            var minNum = new Dictionary<long, long>();
            GenAllProducts(n, maxLen, 0, 1, 0, minNum);
            int count = 0;
            foreach (var kv in minNum)
            {
                if (kv.Value <= n) count++;
            }
            Console.WriteLine(count);
        }
    }
}